package org.deft.extension.test.invoker;

import static org.junit.Assert.assertEquals;

import java.util.HashMap;
import java.util.Map;

import org.deft.extension.decoration.modify.ModifiedDecoratorInvoker;
import org.deft.extension.persistence.PersistenceException;
import org.deft.extension.test.testutil.TestUtil;
import org.deft.repository.ast.TreeNode;
import org.junit.Test;

public class ModifiedDecoratorInvokerTest {
	@Test
	public void testInvoke() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		ModifiedDecoratorInvoker inv = new ModifiedDecoratorInvoker();
		Map<String, String> params = new HashMap<String, String>();
		String location = "//MethodDeclaration";
		params.put("location", location);
		inv.invoke(ast, params);
		assertEquals(ast.executeXPathQuery(location).get(0).getInformation()
				.size(), 2);

	}

	@Test(expected = PersistenceException.class)
	public void testInvokeFail() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		ModifiedDecoratorInvoker inv = new ModifiedDecoratorInvoker();
		Map<String, String> params = new HashMap<String, String>();
		inv.invoke(ast, params);
	}
}
