package org.deft.extension.test.invoker;

import static org.junit.Assert.assertEquals;

import java.util.HashMap;
import java.util.Map;

import org.deft.extension.decoration.style.StyleDecoratorInvoker;
import org.deft.extension.persistence.PersistenceException;
import org.deft.extension.test.testutil.TestUtil;
import org.deft.repository.ast.TreeNode;
import org.junit.Test;

public class StyleDecoratorInvokerTest {
	@Test
	public void testInvoke() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		StyleDecoratorInvoker inv = new StyleDecoratorInvoker();
		Map<String, String> params = new HashMap<String, String>();
		String location = "//MethodDeclaration";
		params.put("location", location);
		params
				.put("container",
						"org.deft.extension.decoration.style.container.CssDeclarationStyleContainer");
		params.put("value", "font-weight:bold;");
		inv.invoke(ast, params);
		assertEquals(ast.executeXPathQuery(location).get(0).getInformation()
				.size(), 2);

	}

	@Test(expected = PersistenceException.class)
	public void testInvokeMissingParameter() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		StyleDecoratorInvoker inv = new StyleDecoratorInvoker();
		Map<String, String> params = new HashMap<String, String>();
		inv.invoke(ast, params);
	}

	@Test(expected = PersistenceException.class)
	public void testInvokeInvalidClass() throws Exception {
		TreeNode ast = TestUtil.readFileInAST("resources/SimpleTestFile.java");
		StyleDecoratorInvoker inv = new StyleDecoratorInvoker();
		Map<String, String> params = new HashMap<String, String>();
		String location = "//MethodDeclaration";
		params.put("location", location);
		params.put("container", "no.class.given");
		params.put("value", "font-weight:bold;");
		inv.invoke(ast, params);
	}
}
