package org.deft.extension.test.testutil;

import java.util.LinkedList;
import java.util.List;

import org.deft.extension.XPath;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.NodeInformation;

public final class ExtensionRepository {
	private RepositoryContainer repositoryContainer;
	private List<Loader> loader;

	private static ExtensionRepository singletonExtensionRepository = new ExtensionRepository();

	private ExtensionRepository() {
		repositoryContainer = new RepositoryContainer();
		loader = new LinkedList<Loader>();
	}

	public static ExtensionRepository getInstance() {
		return singletonExtensionRepository;
	}

	public void addNodeInformation(XPath xpath, NodeInformation nodeInformation) {
		repositoryContainer.insertOrAppend(xpath, nodeInformation);
	}

	public RepositoryContainer getXPathsByIdent(Ident id) {
		return repositoryContainer.copyAndFilterByIdent(id);
	}

	public void clearRepository() {
		repositoryContainer.clear();
	}

	@Override
	public String toString() {
		return repositoryContainer.toString();
	}

	/**
	 * Only one per class.
	 * 
	 */
	public void addLoader(Loader c) {
		for (Loader l : loader) {
			if (l.getClass() == c.getClass()) {
				return;
			}
		}
		loader.add(c);
	}

	public void process(TreeNode root) {
		for (Loader l : loader) {
			l.process(root);
		}
	}
}
