package org.deft.extension.test.testutil;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.deft.extension.XPath;
import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.NodeInformation;

public class RepositoryContainer {
	private LinkedHashMap<XPath, List<NodeInformation>> container;

	public RepositoryContainer() {
		container = new LinkedHashMap<XPath, List<NodeInformation>>();
	}

	public void insertOrAppend(XPath xpath, NodeInformation nodeInformation) {

		List<NodeInformation> newNodeInformations;
		if (someInformationsExists(xpath)) {
			newNodeInformations = getOldNodeInformations(xpath);
		} else {
			newNodeInformations = new LinkedList<NodeInformation>();
		}
		newNodeInformations.add(nodeInformation);
		container.put(xpath, newNodeInformations);
	}

	private boolean someInformationsExists(XPath xpath) {
		return container.containsKey(xpath);
	}

	private List<NodeInformation> getOldNodeInformations(XPath xpath) {
		return container.get(xpath);
	}

	public RepositoryContainer copyAndFilterByIdent(Ident id) {
		RepositoryContainer filteredContainer = new RepositoryContainer();
		for (XPath xpath : container.keySet()) {
			List<NodeInformation> currentNodeInformations = getOldNodeInformations(xpath);

			for (NodeInformation nodeInformationUnderTest : currentNodeInformations) {
				if (nodeInformationUnderTest.getIdent() == id) {
					filteredContainer.insertOrAppend(xpath,
							nodeInformationUnderTest);
				}
			}
		}
		return filteredContainer;
	}

	public List<NodeInformation> get(XPath xpath) {
		return container.get(xpath);
	}

	public void clear() {
		container.clear();
	}

	public Set<XPath> keySet() {
		return container.keySet();
	}

	@Override
	public String toString() {
		return container.toString();
	}

}
