package org.deft.extension.test.testutil;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.List;

import org.deft.extension.XPath;
import org.deft.extension.decoration.style.StyleInformation;
import org.deft.extension.decoration.style.container.StyleContainer;
import org.deft.extension.decoration.style.container.StyleDecoratorException;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.NodeInformation;

public class StyleLoader extends Loader {

	private static ExtensionRepository extensionRepository = ExtensionRepository
			.getInstance();

	public static void loadStylesFromString(String styles) {

		try {
			Class<?> typeOfContainerClass = null;
			String[] lines = styles.split("\n");
			for (int i = 0; i < lines.length; i++) {
				String line = lines[i];
				if (line.charAt(0) == 'T') {
					typeOfContainerClass = Class.forName(line.substring(1));
				} else {
					parseLine(typeOfContainerClass, line);
				}

			}
		} catch (ClassNotFoundException e) {
			throw new StyleDecoratorException("Container class not found in '"
					+ styles + "'");
		} catch (NullPointerException e) {
			throw new StyleDecoratorException("No container class defined in '"
					+ styles + "'");
		} catch (Exception e) {
			throw new StyleDecoratorException("Error (" + e.toString()
					+ ") while parsing '" + styles + "'");
		}
	}

	public static void loadStylesFromFile(String filePath) {
		try {
			BufferedReader in = new BufferedReader(new FileReader(filePath));
			String line = null;
			StringBuilder sb = new StringBuilder();
			while ((line = in.readLine()) != null) {
				sb.append(line);
				sb.append("\n");

			}
			loadStylesFromString(sb.toString());
		} catch (Exception e) {
			throw new StyleDecoratorException("Error (" + e.toString()
					+ ") while parsing '" + filePath + "'");
		}
	}

	private static void parseLine(Class<?> typeOfContainerClass, String line)
			throws Exception {
		String[] arr = line.split(" -> ");
		StyleContainer sc = (StyleContainer) typeOfContainerClass.newInstance();
		StyleInformation si = new StyleInformation();
		si.addStyleContainer(sc);
		sc.parse(arr[1]);
		extensionRepository.addNodeInformation(new XPath(arr[0]), si);
	}

	@Override
	public void process(TreeNode root) {

		RepositoryContainer repositoryContainer = extensionRepository
				.getXPathsByIdent(StyleInformation.IDENT);

		for (XPath xpath : repositoryContainer.keySet()) {
			List<TreeNode> targetNodes = root.executeXPathQuery(xpath
					.toString());

			List<NodeInformation> nil = repositoryContainer.get(xpath);
			List<StyleContainer> styleContainerToAdd = new LinkedList<StyleContainer>();
			for (NodeInformation ni : nil) {
				StyleInformation si = (StyleInformation) ni;
				styleContainerToAdd.addAll(si.getAllStyleContainer());
			}

			for (TreeNode treeNode : targetNodes) {
				NodeInformation ni = treeNode
						.getInformation(StyleInformation.IDENT);
				StyleInformation si;
				if (ni == null) {
					si = new StyleInformation();
				} else {
					si = (StyleInformation) ni;
				}

				si.addAllStyleContainer(deepCopy(styleContainerToAdd));
				treeNode.addInformation(si);
			}
		}
	}

	// Important for grouping. "Same" informations would be merged!!!!
	private List<StyleContainer> deepCopy(
			List<StyleContainer> styleContainerToAdd) {
		List<StyleContainer> ret = new LinkedList<StyleContainer>();
		for (StyleContainer sc : styleContainerToAdd) {
			ret.add(sc.clone());
		}

		return ret;
	}
}
