package org.deft.extension.test.testutil;

import java.io.File;
import java.util.LinkedList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestLoader extends LinkedList<Test> {

	private static final long serialVersionUID = -8028072103924263279L;
	private Test globalTestParameter = new Test("Global");

	public TestLoader(String filePath) throws Exception {
		super();

		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		Document document = builder.parse(new File(filePath));

		extractGlobalParameter(document);
		extractTests(document);

	}

	private void extractGlobalParameter(Document document) {
		NodeList childsOfTestcase = document.getFirstChild().getChildNodes();
		for (int i = 0; i < childsOfTestcase.getLength(); i++) {
			Node child = childsOfTestcase.item(i);
			if (!isTestNode(child) && isRealNode(child)) {
				globalTestParameter.put(child.getNodeName(), child
						.getTextContent());
			}
		}
	}

	private boolean isTestNode(Node child) {
		return child.getNodeName().equals("test");
	}

	private boolean isRealNode(Node child) {
		return !child.getNodeName().equals("#text");
	}

	private void extractTests(Document document) {
		NodeList testNodes = document.getElementsByTagName("test");

		for (int i = 0; i < testNodes.getLength(); i++) {
			Node testNode = testNodes.item(i);

			NodeList childsOfTestNode = testNode.getChildNodes();

			Test test = createTest(testNode);
			test.putAll(globalTestParameter);
			extractLocalParameter(childsOfTestNode, test);
			add(test);
		}
	}

	private void extractLocalParameter(NodeList childsOfTestNode, Test test) {
		for (int j = 0; j < childsOfTestNode.getLength(); j++) {
			Node c = childsOfTestNode.item(j);
			if (isRealNode(c)) {
				test.put(c.getNodeName(), c.getTextContent());
			}
		}
	}

	private Test createTest(Node testNode) {
		NamedNodeMap attributes = testNode.getAttributes();
		Node nameAttr = attributes.getNamedItem("name");
		return new Test(nameAttr.getNodeValue());
	}

}
