package org.deft.extension.test.testutil;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.List;

import org.deft.language.java.parser.JavaParser;
import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.TreeNodeRoot;
import org.deft.repository.ast.decoration.DecoratorSelection;
import org.deft.repository.ast.decoration.OutputXmlCreator;
import org.deft.repository.util.XmlUtil;
import org.w3c.dom.Document;

public final class TestUtil {

	private TestUtil() {

	}

	public static String readFileInString(String filePath) throws Exception {
		StringBuffer fileData = new StringBuffer(1000);
		BufferedReader reader = new BufferedReader(new FileReader(filePath));
		char[] buf = new char[1024];
		int numRead = 0;
		while ((numRead = reader.read(buf)) != -1) {
			fileData.append(buf, 0, numRead);
		}
		reader.close();
		return fileData.toString();
	}

	public static TreeNodeRoot readFileInAST(String filePath) throws Exception {
		TreeNodeRoot root;
		File file = new File(filePath);
		JavaParser jp = new JavaParser();
		root = jp.getAst(file);
		return root;
	}

	public static void printXMLFromAST(TreeNode root) {
		DecoratorSelection decorators = new DecoratorSelection();

		OutputXmlCreator outputCreator = new OutputXmlCreator(root, decorators);
		Document outputXml = outputCreator.createOutputXml();
		XmlUtil.outputXml(outputXml, System.out);
	}

	public static void printXMLFromAST(TreeNode root,
			DecoratorSelection decorators) {
		OutputXmlCreator outputCreator = new OutputXmlCreator(root, decorators);
		Document outputXml = outputCreator.createOutputXml();
		XmlUtil.outputXml(outputXml, System.out);
	}

	public static String tokenNodeListToString(List<TokenNode> nodes,
			String lineBreak) {
		StringBuilder builder = new StringBuilder();
		for (TokenNode node : nodes) {
			builder.append(tokenNodeToString(node));
			builder.append(lineBreak);
		}
		return builder.toString().trim();
	}

	public static String tokenNodeToString(TokenNode node) {
		return node.getName() + ":" + node.getStartLine() + ":"
				+ node.getStartCol() + "-" + node.getEndLine() + ":"
				+ node.getEndCol() + "-" + node.getLength() + " "
				+ node.getOffset();
	}

	public static String astToXMLString(TreeNode root,
			DecoratorSelection decorators) {
		OutputXmlCreator outputCreator = new OutputXmlCreator(root, decorators);
		Document outputXml = outputCreator.createOutputXml();

		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		XmlUtil.outputXml(outputXml, bout);
		return bout.toString();
	}

	public static String astToTreeString(TreeNode ast) {
		return recTreeToString(ast, 0);
	}

	private static String recTreeToString(TreeNode ast, int level) {
		char[] spaces = new char[level * 4];
		Arrays.fill(spaces, ' ');

		StringBuilder sb = new StringBuilder();
		sb.append(spaces);
		sb.append(ast.getName());
		sb.append("\n");

		for (TreeNode child : ast.getChildren()) {

			sb.append(recTreeToString(child, level + 1));
		}
		return sb.toString();
	}
}
