package org.deft.extension.decoration.modify;

import java.util.List;

import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.AstDecorator;
import org.deft.repository.ast.decoration.GroupListBuilder;
import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.NodeInformationPropagator;

/**
 * Visualizes a modification done by the TokenModifier or can be applied manual.
 * to a TokenNode.
 * 
 * @author Martin Heinzerling
 * 
 */

public class ModifiedDecorator extends AstDecorator {

	@Override
	public void applyDecoration(TreeNode root) {
		NodeInformationPropagator propagator = new NodeInformationPropagator(
				root, this);
		propagator.propagateNodeInformationToTokenNodes();
	}

	@Override
	public Ident getIdent() {
		return ModifiedInformation.IDENT;
	}

	@Override
	public void buildAndAddGroupLists(List<TokenNode> tokens) {
		GroupListBuilder<?> grouper = new ModifiedGroupListBuilder(tokens);
		saveGroupList(grouper.getGroupList());
	}
}
