package org.deft.extension.decoration.modify;

import java.util.List;
import java.util.Map;

import org.deft.extension.persistence.Invoker;
import org.deft.extension.persistence.PersistenceException;
import org.deft.repository.ast.TreeNode;

/**
 * Handles a invoker call from a Persistence object and applies a
 * ModifiedInformation to a XPath. <br>
 * Parameter<br>
 * location - xpath
 * 
 * @author Martin Heinzerling
 * 
 */
public class ModifiedDecoratorInvoker implements Invoker {

	@Override
	public void invoke(TreeNode ast, Map<String, String> params) {

		String location = params.get("location");
		if (location == null) {
			throw new PersistenceException("Missing parameter 'location'");
		}
		List<TreeNode> tns = ast.executeXPathQuery(location);
		ModifiedInformation pi = new ModifiedInformation();
		for (TreeNode tn : tns) {
			tn.addInformation(pi);

		}

	}

}
