package org.deft.extension.decoration.modify;

import org.deft.repository.ast.decoration.Group;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * 
 * @author Martin Heinzerling
 * @see Group
 */
public class ModifiedGroup extends Group {

	private boolean modified;

	public ModifiedGroup(boolean modified) {
		this.modified = modified;
	}

	@Override
	protected Element createXmlTag(Document doc) {
		Element e = doc.createElement(ModifiedInformation.IDENT.getIdString());
		return e;
	}

	@Override
	public boolean isDummy() {
		return !isModified();
	}

	public boolean isModified() {
		return modified;
	}

}
