package org.deft.extension.decoration.modify;

import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.NodeInformation;

/**
 * If a ModifiedInformation exists at a TreeNode, the TreeNode was modified.
 * 
 * @author Martin Heinzerling
 * 
 */
public class ModifiedInformation extends NodeInformation {

	// TODO I: Aus Template ausgelagert
	public static final Ident IDENT = new Ident("modified", "modifiedDecorator");

	@Override
	public Ident getIdent() {
		return ModifiedInformation.IDENT;
	}

	@Override
	public NodeInformation copy() {
		return new ModifiedInformation();
	}

	@Override
	public void addContentFromOtherNodeInformation(
			NodeInformation newInformation) {
	}
}
