package org.deft.extension.decoration.protect;

import java.util.List;

import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.AstDecorator;
import org.deft.repository.ast.decoration.GroupListBuilder;
import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.NodeInformationPropagator;

/**
 * Indicates a protected area in the XML representation of the snippet. This
 * area should't be touched by following operations.
 * 
 * @author Martin Heinzerling
 * 
 */
public class ProtectedDecorator extends AstDecorator {

	@Override
	public void applyDecoration(TreeNode root) {
		NodeInformationPropagator propagator = new NodeInformationPropagator(
				root, this);
		propagator.propagateNodeInformationToTokenNodes();
	}

	@Override
	public Ident getIdent() {
		return ProtectedInformation.IDENT;
	}

	@Override
	public void buildAndAddGroupLists(List<TokenNode> tokens) {
		GroupListBuilder<?> grouper = new ProtectedGroupListBuilder(tokens);
		saveGroupList(grouper.getGroupList());
	}
}
