package org.deft.extension.decoration.protect;

import java.util.List;
import java.util.Map;

import org.deft.extension.persistence.Invoker;
import org.deft.extension.persistence.PersistenceException;
import org.deft.repository.ast.TreeNode;

/**
 * Handles a invoker call from a Persistence object and applies a
 * ProtectedInformation to a XPath. <br>
 * Parameter<br>
 * location - xpath<br>
 * 
 * @author Martin Heinzerling
 * 
 */
public class ProtectedDecoratorInvoker implements Invoker {

	@Override
	public void invoke(TreeNode ast, Map<String, String> params) {

		String location = params.get("location");
		if (location == null) {
			throw new PersistenceException("Missing parameter 'location'");
		}
		List<TreeNode> tns = ast.executeXPathQuery(location);
		ProtectedInformation pi = new ProtectedInformation();
		for (TreeNode tn : tns) {
			tn.addInformation(pi);
		}

	}
}
