package org.deft.extension.decoration.protect;

import org.deft.repository.ast.decoration.Group;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * 
 * @author Martin Heinzerling
 * @see Group
 */
public class ProtectedGroup extends Group {

	private boolean protect;

	public ProtectedGroup(boolean protect) {
		this.protect = protect;
	}

	@Override
	protected Element createXmlTag(Document doc) {
		Element e = doc.createElement(ProtectedInformation.IDENT.getIdString());
		return e;
	}

	@Override
	public boolean isDummy() {
		return !isProtected();
	}

	public boolean isProtected() {
		return protect;
	}

}
