package org.deft.extension.decoration.protect;

import java.util.List;

import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.decoration.GroupListBuilder;

/**
 * 
 * @author Martin Heinzerling
 * @see GroupListBuilder
 */
public class ProtectedGroupListBuilder extends GroupListBuilder<ProtectedGroup> {

	public ProtectedGroupListBuilder(List<TokenNode> nodes) {
		super(nodes);
	}

	@Override
	public boolean belongsToGroup(ProtectedGroup group, TokenNode tn) {

		ProtectedInformation pi = (ProtectedInformation) tn
				.getInformation(ProtectedInformation.IDENT);

		if (group.isProtected()) {
			if (pi == null) {
				return false;
			}
			return true;

		} else {
			if (pi == null) {
				return true;
			}

			return false;
		}
	}

	@Override
	public ProtectedGroup createNewGroup(TokenNode tn) {
		ProtectedInformation pi = (ProtectedInformation) tn
				.getInformation(ProtectedInformation.IDENT);
		if (pi == null) {
			return new ProtectedGroup(false);
		}
		return new ProtectedGroup(true);
	}
}
