package org.deft.extension.decoration.protect;

import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.NodeInformation;

/**
 * After transformation from a TokenNode to XML, this information indicates not
 * to modify it anymore.
 * 
 * @author Martin Heinzerling
 * 
 */
public class ProtectedInformation extends NodeInformation {

	// TODO I: Aus Template ausgelagert
	public static final Ident IDENT = new Ident("protected",
			"protectedDecorator");

	@Override
	public Ident getIdent() {
		return ProtectedInformation.IDENT;
	}

	@Override
	public NodeInformation copy() {
		return new ProtectedInformation();
	}

	@Override
	public void addContentFromOtherNodeInformation(
			NodeInformation newInformation) {
	}
}
