package org.deft.extension.decoration.style;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.deft.extension.decoration.style.container.StyleContainer;
import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.AstDecorator;
import org.deft.repository.ast.decoration.GroupListBuilder;
import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.NodeInformationPropagator;

/**
 * Applies different style and formating information to a TreeNode.
 * 
 * @author Martin Heinzerling
 * 
 */
public class StyleDecorator extends AstDecorator {

	private Set<StyleContainer> styleContainerSet = new LinkedHashSet<StyleContainer>();

	public StyleDecorator() {
	}

	@Override
	public void applyDecoration(TreeNode root) {
		NodeInformationPropagator propagator = new NodeInformationPropagator(
				root, this);
		propagator.propagateNodeInformationToTokenNodes();

		List<TokenNode> tokens = root.serialize();
		for (TokenNode tn : tokens) {
			if (tn.hasInformation(getIdent())) {
				collectStyleContainer(tn);
			}
		}
	}

	private void collectStyleContainer(TokenNode tn) {
		StyleInformation si = (StyleInformation) tn.getInformation(getIdent());
		for (int i = 0; i < si.getStyleContainerCount(); i++) {
			StyleContainer sc = si.getStyleContainer(i);
			styleContainerSet.add(sc);
		}
	}

	@Override
	public void buildAndAddGroupLists(List<TokenNode> tokens) {
		if (styleContainerSet.isEmpty()) {
			GroupListBuilder<?> grouper = new StyleGroupListBuilder(tokens,
					null);
			saveGroupList(grouper.getGroupList());
		} else {
			for (StyleContainer sc : styleContainerSet) {
				GroupListBuilder<?> grouper = new StyleGroupListBuilder(tokens,
						sc);
				saveGroupList(grouper.getGroupList());
			}
		}
	}

	@Override
	public Ident getIdent() {
		return StyleInformation.IDENT;
	}

}