package org.deft.extension.decoration.style;

import java.util.List;
import java.util.Map;

import org.deft.extension.decoration.style.container.StyleContainer;
import org.deft.extension.persistence.Invoker;
import org.deft.extension.persistence.PersistenceException;
import org.deft.repository.ast.TreeNode;

/**
 * Handles a invoker call from a Persistence object and applies a
 * StyleInformation to a XPath. <br>
 * Parameter <br>
 * location - xpath<br>
 * container - {@link StyleContainer}<br>
 * value - string representation of container content
 * 
 * @author Martin Heinzerling
 * 
 */
public class StyleDecoratorInvoker implements Invoker {

	@Override
	public void invoke(TreeNode ast, Map<String, String> params) {
		String location = params.get("location");
		String container = params.get("container");
		String value = params.get("value");
		if (location == null || container == null || value == null) {
			throw new PersistenceException(
					"Parameter 'location', 'container' and 'value' required");
		}

		StyleInformation si = createStyleInformation(container, value);
		List<TreeNode> tns = ast.executeXPathQuery(location);

		for (TreeNode tn : tns) {
			tn.addInformation(si);

		}
	}

	private StyleInformation createStyleInformation(String container,
			String value) {
		StyleInformation si;
		StyleContainer sc;
		try {
			sc = (StyleContainer) Class.forName(container).newInstance();
		} catch (Exception e) {
			throw new PersistenceException("Invalid class: " + container);
		}
		sc.parse(value);
		si = new StyleInformation();
		si.addStyleContainer(sc);
		return si;
	}
}
