package org.deft.extension.decoration.style;

import org.deft.extension.decoration.style.container.StyleContainer;
import org.deft.repository.ast.decoration.Group;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * 
 * @author Martin Heinzerling
 * @see Group
 */
public class StyleGroup extends Group {

	private StyleContainer styleContainer;

	public StyleGroup(StyleContainer styleContainer) {
		this.styleContainer = styleContainer;
	}

	@Override
	protected Element createXmlTag(Document doc) {
		Element e = doc.createElement(StyleInformation.IDENT.getIdString());
		e.setAttribute("id", styleContainer.renderIdAttribute());
		e.setAttribute("value", styleContainer.renderValueAttribute());
		return e;
	}

	@Override
	public boolean isDummy() {
		return !hasStyle();
	}

	/**
	 * 
	 * @return False if no StyleContainer exists in group.
	 */
	public boolean hasStyle() {
		return styleContainer != null;
	}

	public StyleContainer getStyleContainer() {
		return styleContainer;
	}

}
