package org.deft.extension.decoration.style;

import java.util.List;

import org.deft.extension.decoration.style.container.StyleContainer;
import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.decoration.GroupListBuilder;

/**
 * New Group for every StyleContainer.
 * 
 * @author Martin Heinzerling
 * @see GroupListBuilder
 */
public class StyleGroupListBuilder extends GroupListBuilder<StyleGroup> {

	private StyleContainer styleContainer;

	public StyleGroupListBuilder(List<TokenNode> nodes,
			StyleContainer styleContainer) {
		super(nodes);
		this.styleContainer = styleContainer;
	}

	@Override
	public boolean belongsToGroup(StyleGroup group, TokenNode tn) {

		StyleInformation si = (StyleInformation) tn
				.getInformation(StyleInformation.IDENT);

		if (group.hasStyle()) {
			// group has style and the tn not -> false
			if (si == null) {
				return false;
			}

			// group has style and the tn contains a style information
			// with the same style container -> true
			// group has style but there was no style information at the tn
			// into which the grouper is interested -> false

			StyleContainer sc = group.getStyleContainer();
			return si.containerExists(sc);

		} else {
			// group has no style and tn too -> true
			if (si == null) {
				return true;
			}

			// group has no style, but among the style information of the tn
			// there is a style information that this grouper is interested in
			// (meaning that the tn is considered styled and does not belong
			// to the (unstyled) group) -> false
			// group has no style, and among the style information there
			// is none that this grouper is interested in (meaning that
			// the tn is to be considered unstyled, too) ->true
			return !si.containerExists(styleContainer);

		}
	}

	@Override
	public StyleGroup createNewGroup(TokenNode tn) {
		StyleInformation si = (StyleInformation) tn
				.getInformation(StyleInformation.IDENT);
		if (si == null) {
			// No style information -> empty group
			return new StyleGroup(null);
		}
		if (si.containerExists(styleContainer)) {
			StyleGroup sg = new StyleGroup(styleContainer);
			return sg;
		}

		// There were style information available, but none that this grouper is
		// interested in. Make empty group.
		return new StyleGroup(null);
	}

}
