package org.deft.extension.decoration.style;

import java.util.LinkedList;
import java.util.List;

import org.deft.extension.decoration.style.container.StyleContainer;
import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.NodeInformation;

/**
 * StyleInformation store multiple StyleContainer, which provide different
 * formating information for the sourcecode in xml.
 * 
 * @author Martin Heinzerling
 * 
 */
public class StyleInformation extends NodeInformation {

	// TODO I: Aus Template ausgelagert
	public static final Ident IDENT = new Ident("style", "styleDecoration");

	private List<StyleContainer> styleContainerList = new LinkedList<StyleContainer>();

	@Override
	public Ident getIdent() {
		return StyleInformation.IDENT;
	}

	/**
	 * 
	 * @param index
	 *            of StyleContainer
	 * @return StyleContainer
	 */
	public StyleContainer getStyleContainer(int index) {
		return styleContainerList.get(index);
	}

	public List<StyleContainer> getAllStyleContainer() {

		return styleContainerList;
	}

	public int getStyleContainerCount() {
		return styleContainerList.size();
	}

	/**
	 * 
	 * @param sc
	 *            StyleContainer
	 */
	public void addStyleContainer(StyleContainer sc) {
		styleContainerList.add(sc);
	}

	/**
	 * 
	 * @param scs
	 *            StyleContainer
	 */
	public void addAllStyleContainer(List<StyleContainer> scs) {
		styleContainerList.addAll(scs);
	}

	/**
	 * 
	 * @param container
	 *            StyleContainer
	 * @return true if given container exist in container list of the
	 *         StyleInformation
	 */
	public boolean containerExists(StyleContainer container) {
		for (StyleContainer sc : styleContainerList) {
			if (sc == container) {
				return true;
			}
		}
		return false;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("(");
		for (StyleContainer sc : styleContainerList) {
			sb.append(sc.renderIdAttribute());
			sb.append(" - ");
			sb.append(sc.renderValueAttribute());
			sb.append(", ");
		}
		sb.replace(sb.length() - 2, sb.length(), "");
		sb.append(")");
		return sb.toString();
	}

	@Override
	public void addContentFromOtherNodeInformation(
			NodeInformation newInformation) {
		if (newInformation instanceof StyleInformation) {
			StyleInformation newSI = (StyleInformation) newInformation;
			styleContainerList.addAll(newSI.styleContainerList);
		}
	}

	@Override
	public NodeInformation copy() {
		StyleInformation si = new StyleInformation();
		si.addContentFromOtherNodeInformation(this);
		return si;
	}

}
