package org.deft.extension.decoration.style.container;

import java.util.LinkedList;

/**
 * Holds CSS information for HTML class-attribute.
 * 
 * css=[class]
 * 
 * @author Martin Heinzerling
 * 
 */
public class CssClassStyleContainer extends StyleContainer {
	private LinkedList<String> classes = new LinkedList<String>();

	public CssClassStyleContainer() {

	}

	public CssClassStyleContainer(String text) {
		parse(text);
	}

	private CssClassStyleContainer(LinkedList<String> classes) {
		this.classes = classes;
	}

	@Override
	public void parse(String text) {
		classes = splitInClasses(text);

	}

	private LinkedList<String> splitInClasses(String text) {
		String[] classes = text.split(" ");
		LinkedList<String> ret = new LinkedList<String>();
		for (String clas : classes) {
			if (clas.length() > 0) {
				ret.add(clas);
			}
		}
		return ret;
	}

	@Override
	public String renderValueAttribute() {
		StringBuilder result = new StringBuilder();
		for (String clas : classes) {
			result.append(clas + " ");
		}
		if (result.length() > 0) {
			result.delete(result.length() - 1, result.length());
		}
		return result.toString();
	}

	@Override
	public String renderIdAttribute() {

		return "CSSClass";
	}

	@SuppressWarnings("unchecked")
	@Override
	public CssClassStyleContainer clone() {
		return new CssClassStyleContainer((LinkedList<String>) classes.clone());
	}

}
