package org.deft.extension.decoration.style.container;

import java.util.LinkedHashMap;

/**
 * Holds information in Cascading Style Sheets format.
 * 
 * css=[declaration] declaration=value:property;
 * 
 * @author Martin Heinzerling
 * 
 */
public class CssDeclarationStyleContainer extends StyleContainer {

	private LinkedHashMap<String, String> cssDeclarations = new LinkedHashMap<String, String>();

	public CssDeclarationStyleContainer() {

	}

	public CssDeclarationStyleContainer(String text) {
		parse(text);
	}

	private CssDeclarationStyleContainer(
			LinkedHashMap<String, String> cssDeclarations) {
		this.cssDeclarations = cssDeclarations;
	}

	@Override
	public void parse(String text) {
		try {
			String[] declarations = splitInDeclarations(text);

			for (String declaration : declarations) {
				declaration = declaration.trim();
				if (isDeclaration(declaration)) {
					String[] parts = splitDeclaration(declaration);
					String property = parts[0].trim();
					String value = parts[1].trim();
					cssDeclarations.put(property, value);
				}
			}
		} catch (Exception e) {
			throw new StyleDecoratorException(
					"Error while parsing CSS style information.");
		}
	}

	private String[] splitInDeclarations(String text) throws Exception {
		return text.split(";");
	}

	private boolean isDeclaration(String declaration) {
		return declaration.length() > 0;
	}

	private String[] splitDeclaration(String declaration) {
		return declaration.split(":");
	}

	@Override
	public String renderValueAttribute() {
		StringBuilder result = new StringBuilder();
		for (String property : cssDeclarations.keySet()) {
			String value = cssDeclarations.get(property);
			result.append(buildCSSDeclaration(property, value));
		}
		return result.toString().trim();
	}

	private String buildCSSDeclaration(String property, String value) {
		return property + ":" + value + "; ";
	}

	@Override
	public String renderIdAttribute() {
		return "CSSDeclaration";
	}

	@SuppressWarnings("unchecked")
	@Override
	public CssDeclarationStyleContainer clone() {
		return new CssDeclarationStyleContainer(
				(LinkedHashMap<String, String>) cssDeclarations.clone());
	}

}
