package org.deft.extension.decoration.style.container;

/**
 * Stores style information for a node in the AST.
 * 
 * @author Martin Heinzerling
 * 
 */
public abstract class StyleContainer {
	public StyleContainer() {
		parse("");

	}

	public StyleContainer(String text) {
		parse(text);
	}

	/**
	 * Loads informations from a string to the Container.
	 * 
	 * @param text
	 *            String
	 */
	public abstract void parse(String text);

	// TODO I: Style language in cooperation with the exporter needed
	/**
	 * Returns the string representation of its content for the value attribute
	 * of the XML representation.
	 * 
	 * @return String
	 */
	public abstract String renderValueAttribute();

	/**
	 * Needed for the possibility of mixed StyleContainer.
	 * 
	 * @return String id attribute for XML representation
	 */
	public abstract String renderIdAttribute();

	@Override
	public abstract StyleContainer clone();

}
