package org.deft.extension.tools.astmodifier.comment;

import java.util.List;

import org.deft.repository.ast.TreeNode;

/**
 * Defines an interface for transformation from treenodes of the AST to comment
 * nodes.
 * 
 * @author Martin Heinzerling
 * 
 */
public abstract class CommentTypeVisitor {
	/**
	 * Transform treenodes in a list of comment nodes.
	 * 
	 * @param nodes
	 *            treenodes
	 * @return List of comment nodes
	 * @pre nodes.size>0
	 */
	public abstract List<TreeNode> execute(List<TreeNode> nodes);

	/**
	 * A list of treenodes is flated to its textual representation.
	 * 
	 * @param nodes
	 *            treenodes
	 * @return textual representation
	 */
	protected String treenodesToString(List<TreeNode> nodes) {
		StringBuilder sb = new StringBuilder();
		TreeNode prev = null;

		for (TreeNode tn : nodes) {
			if (prev != null) {
				sb.append(prev.getTextContent());
				String spaces = prev.computeSpacesBetweenPositions(prev
						.getEndLine(), prev.getEndCol(), tn.getStartLine(), tn
						.getStartCol());
				sb.append(spaces);
			}
			prev = tn;

		}
		sb.append(prev.getTextContent());
		return sb.toString();
	}

}
