package org.deft.extension.tools.astmodifier.comment;

import java.util.LinkedList;
import java.util.List;

import org.deft.repository.ast.Token;
import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.TreeNode;

/**
 * Transforms treenodes in java block comments(/* * /).
 * 
 * @author Martin Heinzerling
 * 
 */
public class JavaBlockCommentVisitor extends CommentTypeVisitor {

	@Override
	public List<TreeNode> execute(List<TreeNode> nodes) {
		String flat = "/*" + treenodesToString(nodes) + "*/";

		TokenNode comment = new TokenNode("Comment", new Token(1, 1, 0, flat));
		// Dummy values, will be rearranged after replace

		List<TreeNode> ret = new LinkedList<TreeNode>();
		ret.add(comment);
		return ret;
	}
}
