package org.deft.extension.tools.astmodifier.comment;

import java.util.LinkedList;
import java.util.List;

import org.deft.repository.ast.Token;
import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.TreeNode;

/**
 * Transforms treenodes in java line comments(//).
 * 
 * @author Martin Heinzerling
 * 
 */
public class JavaLineCommentVisitor extends CommentTypeVisitor {

	@Override
	public List<TreeNode> execute(List<TreeNode> nodes) {
		String flat = treenodesToString(nodes);
		List<TreeNode> ret = new LinkedList<TreeNode>();
		String[] lines = flat.split("\n");

		for (String line : lines) {
			TokenNode comment = new TokenNode("Comment", new Token(1, 1, 0,
					"// " + line));
			// Dummy values, will be rearranged after replace
			ret.add(comment);
		}
		return ret;
	}
}
