package org.deft.extension.tools.astmodifier.syntax;

import org.deft.repository.ast.TreeNode;

/**
 * Visitor to check if a TreeNode could be inserted syntactical correct under an
 * other.
 * 
 * @author Martin Heinzerling
 * 
 */
// TODO O: JavaSyntaxChecker
public abstract class SyntaxCheckerVisitor {
	/**
	 * Checks if a insertion is syntactical correct.
	 * 
	 * @param parent
	 *            TreeNode parent node
	 * @param insert
	 *            TreeNode node to insert
	 * @param insertAt
	 *            int index of position in parents childs
	 * @return true if insertion is syntactical correct.
	 */
	public abstract boolean check(TreeNode parent, TreeNode insert, int insertAt);

}
