// $ANTLR 3.1.1 CStyleCommentsLexer.g 2009-02-18 16:27:53

package org.deft.language.java.parser;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
public class CStyleCommentsLexer extends Lexer {
    public static final int Stringliteral=8;
    public static final int Newlinecharacter=4;
    public static final int Singlelinecomment=7;
    public static final int Newline=5;
    public static final int Delimitedcomment=6;
    public static final int EOF=-1;

    // delegates
    // delegators

    public CStyleCommentsLexer() {;} 
    public CStyleCommentsLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public CStyleCommentsLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);

    }
    public String getGrammarFileName() { return "CStyleCommentsLexer.g"; }

    public Token nextToken() {
        while (true) {
            if ( input.LA(1)==CharStream.EOF ) {
                return Token.EOF_TOKEN;
            }
            state.token = null;
    	state.channel = Token.DEFAULT_CHANNEL;
            state.tokenStartCharIndex = input.index();
            state.tokenStartCharPositionInLine = input.getCharPositionInLine();
            state.tokenStartLine = input.getLine();
    	state.text = null;
            try {
                int m = input.mark();
                state.backtracking=1; 
                state.failed=false;
                mTokens();
                state.backtracking=0;

                if ( state.failed ) {
                    input.rewind(m);
                    input.consume(); 
                }
                else {
                    emit();
                    return state.token;
                }
            }
            catch (RecognitionException re) {
                // shouldn't happen in backtracking mode, but...
                reportError(re);
                recover(re);
            }
        }
    }

    public void memoize(IntStream input,
    		int ruleIndex,
    		int ruleStartIndex)
    {
    if ( state.backtracking>1 ) super.memoize(input, ruleIndex, ruleStartIndex);
    }

    public boolean alreadyParsedRule(IntStream input, int ruleIndex) {
    if ( state.backtracking>1 ) return super.alreadyParsedRule(input, ruleIndex);
    return false;
    }// $ANTLR start "Newline"
    public final void mNewline() throws RecognitionException {
        try {
            int _type = Newline;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // CStyleCommentsLexer.g:14:5: ( Newlinecharacter )
            // CStyleCommentsLexer.g:14:9: Newlinecharacter
            {
            mNewlinecharacter(); if (state.failed) return ;
            if ( state.backtracking==1 ) {
              _channel=HIDDEN;
            }

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "Newline"

    // $ANTLR start "Newlinecharacter"
    public final void mNewlinecharacter() throws RecognitionException {
        try {
            // CStyleCommentsLexer.g:20:5: ( '\\r\\n' | '\\r' | '\\n' | '\\u0085' | '\\u2028' | '\\u2029' )
            int alt1=6;
            switch ( input.LA(1) ) {
            case '\r':
                {
                int LA1_1 = input.LA(2);

                if ( (LA1_1=='\n') ) {
                    alt1=1;
                }
                else {
                    alt1=2;}
                }
                break;
            case '\n':
                {
                alt1=3;
                }
                break;
            case '\u0085':
                {
                alt1=4;
                }
                break;
            case '\u2028':
                {
                alt1=5;
                }
                break;
            case '\u2029':
                {
                alt1=6;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 1, 0, input);

                throw nvae;
            }

            switch (alt1) {
                case 1 :
                    // CStyleCommentsLexer.g:20:9: '\\r\\n'
                    {
                    match("\r\n"); if (state.failed) return ;


                    }
                    break;
                case 2 :
                    // CStyleCommentsLexer.g:21:7: '\\r'
                    {
                    match('\r'); if (state.failed) return ;

                    }
                    break;
                case 3 :
                    // CStyleCommentsLexer.g:22:9: '\\n'
                    {
                    match('\n'); if (state.failed) return ;

                    }
                    break;
                case 4 :
                    // CStyleCommentsLexer.g:23:9: '\\u0085'
                    {
                    match('\u0085'); if (state.failed) return ;

                    }
                    break;
                case 5 :
                    // CStyleCommentsLexer.g:24:9: '\\u2028'
                    {
                    match('\u2028'); if (state.failed) return ;

                    }
                    break;
                case 6 :
                    // CStyleCommentsLexer.g:25:9: '\\u2029'
                    {
                    match('\u2029'); if (state.failed) return ;

                    }
                    break;

            }
        }
        finally {
        }
    }
    // $ANTLR end "Newlinecharacter"

    // $ANTLR start "Delimitedcomment"
    public final void mDelimitedcomment() throws RecognitionException {
        try {
            int _type = Delimitedcomment;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // CStyleCommentsLexer.g:31:5: ( '/*' ( options {greedy=false; } : . )* '*/' )
            // CStyleCommentsLexer.g:31:9: '/*' ( options {greedy=false; } : . )* '*/'
            {
            match("/*"); if (state.failed) return ;

            // CStyleCommentsLexer.g:31:14: ( options {greedy=false; } : . )*
            loop2:
            do {
                int alt2=2;
                int LA2_0 = input.LA(1);

                if ( (LA2_0=='*') ) {
                    int LA2_1 = input.LA(2);

                    if ( (LA2_1=='/') ) {
                        alt2=2;
                    }
                    else if ( ((LA2_1>='\u0000' && LA2_1<='.')||(LA2_1>='0' && LA2_1<='\uFFFF')) ) {
                        alt2=1;
                    }


                }
                else if ( ((LA2_0>='\u0000' && LA2_0<=')')||(LA2_0>='+' && LA2_0<='\uFFFF')) ) {
                    alt2=1;
                }


                switch (alt2) {
            	case 1 :
            	    // CStyleCommentsLexer.g:31:42: .
            	    {
            	    matchAny(); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);

            match("*/"); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "Delimitedcomment"

    // $ANTLR start "Singlelinecomment"
    public final void mSinglelinecomment() throws RecognitionException {
        try {
            int _type = Singlelinecomment;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // CStyleCommentsLexer.g:35:5: ( '//' (~ ( Newlinecharacter ) )* )
            // CStyleCommentsLexer.g:35:7: '//' (~ ( Newlinecharacter ) )*
            {
            match("//"); if (state.failed) return ;

            // CStyleCommentsLexer.g:35:12: (~ ( Newlinecharacter ) )*
            loop3:
            do {
                int alt3=2;
                int LA3_0 = input.LA(1);

                if ( ((LA3_0>='\u0000' && LA3_0<='\t')||(LA3_0>='\u000B' && LA3_0<='\f')||(LA3_0>='\u000E' && LA3_0<='\u0084')||(LA3_0>='\u0086' && LA3_0<='\u2027')||(LA3_0>='\u202A' && LA3_0<='\uFFFF')) ) {
                    alt3=1;
                }


                switch (alt3) {
            	case 1 :
            	    // CStyleCommentsLexer.g:35:12: ~ ( Newlinecharacter )
            	    {
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='\t')||(input.LA(1)>='\u000B' && input.LA(1)<='\f')||(input.LA(1)>='\u000E' && input.LA(1)<='\u0084')||(input.LA(1)>='\u0086' && input.LA(1)<='\u2027')||(input.LA(1)>='\u202A' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();
            	    state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop3;
                }
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "Singlelinecomment"

    // $ANTLR start "Stringliteral"
    public final void mStringliteral() throws RecognitionException {
        try {
            int _type = Stringliteral;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // CStyleCommentsLexer.g:39:5: ( '\\\"' ( options {greedy=false; } : ~ ( Newlinecharacter ) )* '\\\"' )
            // CStyleCommentsLexer.g:39:9: '\\\"' ( options {greedy=false; } : ~ ( Newlinecharacter ) )* '\\\"'
            {
            match('\"'); if (state.failed) return ;
            // CStyleCommentsLexer.g:39:14: ( options {greedy=false; } : ~ ( Newlinecharacter ) )*
            loop4:
            do {
                int alt4=2;
                int LA4_0 = input.LA(1);

                if ( (LA4_0=='\"') ) {
                    alt4=2;
                }
                else if ( ((LA4_0>='\u0000' && LA4_0<='\t')||(LA4_0>='\u000B' && LA4_0<='\f')||(LA4_0>='\u000E' && LA4_0<='!')||(LA4_0>='#' && LA4_0<='\u0084')||(LA4_0>='\u0086' && LA4_0<='\u2027')||(LA4_0>='\u202A' && LA4_0<='\uFFFF')) ) {
                    alt4=1;
                }


                switch (alt4) {
            	case 1 :
            	    // CStyleCommentsLexer.g:39:43: ~ ( Newlinecharacter )
            	    {
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='\t')||(input.LA(1)>='\u000B' && input.LA(1)<='\f')||(input.LA(1)>='\u000E' && input.LA(1)<='\u0084')||(input.LA(1)>='\u0086' && input.LA(1)<='\u2027')||(input.LA(1)>='\u202A' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();
            	    state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop4;
                }
            } while (true);

            match('\"'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "Stringliteral"

    public void mTokens() throws RecognitionException {
        // CStyleCommentsLexer.g:1:39: ( Newline | Delimitedcomment | Singlelinecomment | Stringliteral )
        int alt5=4;
        switch ( input.LA(1) ) {
        case '\n':
        case '\r':
        case '\u0085':
        case '\u2028':
        case '\u2029':
            {
            alt5=1;
            }
            break;
        case '\"':
            {
            alt5=4;
            }
            break;
        case '/':
            {
            int LA5_3 = input.LA(2);

            if ( (synpred2_CStyleCommentsLexer()) ) {
                alt5=2;
            }
            else if ( (synpred3_CStyleCommentsLexer()) ) {
                alt5=3;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 5, 3, input);

                throw nvae;
            }
            }
            break;
        default:
            if (state.backtracking>0) {state.failed=true; return ;}
            NoViableAltException nvae =
                new NoViableAltException("", 5, 0, input);

            throw nvae;
        }

        switch (alt5) {
            case 1 :
                // CStyleCommentsLexer.g:1:41: Newline
                {
                mNewline(); if (state.failed) return ;

                }
                break;
            case 2 :
                // CStyleCommentsLexer.g:1:49: Delimitedcomment
                {
                mDelimitedcomment(); if (state.failed) return ;

                }
                break;
            case 3 :
                // CStyleCommentsLexer.g:1:66: Singlelinecomment
                {
                mSinglelinecomment(); if (state.failed) return ;

                }
                break;
            case 4 :
                // CStyleCommentsLexer.g:1:84: Stringliteral
                {
                mStringliteral(); if (state.failed) return ;

                }
                break;

        }

    }

    // $ANTLR start synpred2_CStyleCommentsLexer
    public final void synpred2_CStyleCommentsLexer_fragment() throws RecognitionException {   
        // CStyleCommentsLexer.g:1:49: ( Delimitedcomment )
        // CStyleCommentsLexer.g:1:49: Delimitedcomment
        {
        mDelimitedcomment(); if (state.failed) return ;

        }
    }
    // $ANTLR end synpred2_CStyleCommentsLexer

    // $ANTLR start synpred3_CStyleCommentsLexer
    public final void synpred3_CStyleCommentsLexer_fragment() throws RecognitionException {   
        // CStyleCommentsLexer.g:1:66: ( Singlelinecomment )
        // CStyleCommentsLexer.g:1:66: Singlelinecomment
        {
        mSinglelinecomment(); if (state.failed) return ;

        }
    }
    // $ANTLR end synpred3_CStyleCommentsLexer

    public final boolean synpred2_CStyleCommentsLexer() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred2_CStyleCommentsLexer_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred3_CStyleCommentsLexer() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred3_CStyleCommentsLexer_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }


 

}