package org.deft.language.java.parser;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

import org.deft.repository.ast.TreeNode;

public class TreeNodeContainer {
	private final Map<Integer, TreeNode> childNodes = new TreeMap<Integer, TreeNode>();
	
	private TreeNode treeNode;
	
	public TreeNodeContainer(TreeNode treeNode) {
		this.treeNode = treeNode;
	}

	public TreeNode getTreeNode() {
		return treeNode;
	}
	
	public void setTreeNode(TreeNode treeNode) {
		this.treeNode = treeNode;
	}
	
	public void addChild(int pos, TreeNode child) {
		childNodes.put(pos, child);
	}
	
	public Collection<TreeNode> getSortedChildren() {
		return childNodes.values();
	}
}
