package org.deft.language.java.parser.antlradapter;

import java.util.List;

import org.antlr.runtime.CommonToken;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.TreeAdaptor;
import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.TreeNode;


public class DeftTreeAdaptor implements TreeAdaptor {
    
    private Mapping mapping;    
        
    public DeftTreeAdaptor(Mapping mapping) {
        this.mapping = mapping;
    }
    

    public void addChild(Object t, Object child) {
        TreeNode eParent = (TreeNode)t;
        TreeNode eChild = (TreeNode)child;
        if (eParent != null && eChild != null) {
            doAddChild(eParent, eChild);
        }       
    }
    
    //for debugging purposes
    @SuppressWarnings(value="unused")
    private String getTreeString(TreeNode e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getName());
        List<TreeNode> nl = e.getChildren();
        if (nl.size() > 0) {
            sb.append(" ( ");
            for (int i = 0; i < nl.size(); i++) {
                TreeNode n = nl.get(i);
                if (n instanceof TokenNode) {
                    sb.append("\"").append(((TokenNode)n).getToken().getText()).append("\"");
                } else {
                    sb.append(getTreeString((TreeNode)nl.get(i)));
                }
            }
            sb.append(" ) ");
        }
        return sb.toString();
    }

    public Object becomeRoot(Object newRoot, Object oldRoot) {
        if (oldRoot == null) {
            return newRoot;
        }
        TreeNode dOldRoot = (TreeNode)oldRoot;
        TreeNode dNewRoot = (TreeNode)newRoot;        
        if (isNil(dNewRoot)) {
            if (dNewRoot.getChildren().size() > 1 ) {
                throw new RuntimeException("more than one node as root");
            }
            dNewRoot = (TreeNode)dNewRoot.getChildren().get(0);
        }               
        doAddChild(dNewRoot, dOldRoot);
        return dNewRoot;
    }

    private void doAddChild(TreeNode dParent, TreeNode dChild) {
        if (isNil(dChild)) {
            List<TreeNode> nl = dChild.getChildren();
            while (nl.size() > 0) { 
                dParent.addChild(nl.get(0));
            }               
        } else {
            dParent.addChild(dChild);
        }
        
    }
    
    
    public Object becomeRoot(Token newRoot, Object oldRoot) {
        // Auto-generated method stub
        return null;
    }

    public Object create(Token payload) {
        if (payload == null) {
            TreeNode dNil = (TreeNode)nil();
            return dNil;
        }
        
        String name = mapping.getTokenName(payload);
        int line = payload.getLine();
        int col = payload.getCharPositionInLine() + 1;
        int offset = mapping.convertPosition(line - 1, col - 1);
        String text = payload.getText();
        org.deft.repository.ast.Token deftToken = new org.deft.repository.ast.Token(line, col, offset, text);
        return new TokenNode(name, deftToken);
    }

    public Object create(int tokenType, Token fromToken) {
        Token tok2 = new CommonToken(fromToken);
        tok2.setType(tokenType);
        return create(tok2);
    }

    public Object create(int tokenType, String text) {
        String name = mapping.getTokenName(text, tokenType);
        TreeNode e = new TreeNode(name);
        return e;
    }

    public Object create(int tokenType, Token fromToken, String text) {
        Token tok2 = new CommonToken(fromToken);
        tok2.setType(tokenType);
        tok2.setText(text);
        return create(tok2);
    }

    public Object dupNode(Object treeNode) {
        //Auto-generated method stub
        return null;
    }

    public Object dupTree(Object tree) {
        //Auto-generated method stub
        return null;
    }

    public Object getChild(Object t, int i) {
        //Auto-generated method stub
        return null;
    }

    public int getChildCount(Object t) {
        //Auto-generated method stub
        return 0;
    }

    public String getText(Object t) {
        //Auto-generated method stub
        return null;
    }

    public Token getToken(Object t) {
        //Auto-generated method stub
        return null;
    }

    public int getTokenStartIndex(Object t) {
        //Auto-generated method stub
        return 0;
    }

    public int getTokenStopIndex(Object t) {
        //Auto-generated method stub
        return 0;
    }

    public int getType(Object t) {
        //Auto-generated method stub
        return 0;
    }

    public int getUniqueID(Object node) {
        //Auto-generated method stub
        return 0;
    }

    public boolean isNil(Object tree) {
        return tree instanceof NilNode;
    }

    public Object nil() {
        return new NilNode();
    }

    /** Transform ^(nil x) to x */
    public Object rulePostProcessing(Object root) {
        TreeNode t = (TreeNode)root;
        if ( t != null && isNil(t) && t.getChildCount() == 1 ) {           
            t = (TreeNode) t.getFirstChild();
            //if we build an incomplete AST as with the C# Preprocessor parser
            //there might be imaginary tokens without children after the tree rewrite.
            //This causes the creation of TreeNodes (via method create(int, String)) without
            //children. However, in a DEFT tree only TokenNodes are allowed as leaf children.
            //Therefore find those leaf TreeNodes and add a virtual token node to them.
            t = fixLeafTreeNode(t);
        }
        return t;
    }
    
    private TreeNode fixLeafTreeNode(TreeNode t) {
        //if we have a leaf tree node
        if (!(t instanceof TokenNode) && t.getChildCount() == 0) {
            t.addChild(new VirtualTokenNode());
        }
        return t;
    }

    public void setText(Object t, String text) {
        //Auto-generated method stub
        
    }

    public void setTokenBoundaries(Object t, Token startToken, Token stopToken) {
    }
    

    public void setType(Object t, int type) {
        //Auto-generated method stub
        
    }
    
    private class NilNode extends TreeNode {
        public NilNode() {
            super("NIL");
        }        
    }
    
    private class VirtualTokenNode extends TokenNode {

        public VirtualTokenNode() {
            super("_virtual_", new org.deft.repository.ast.Token(-1, -1, -1, ""));
        }
        
        public int getOffset() {
            if (isLocked()) {
                return -1;
            }
            //first find an ancestor node for which we have a real offset
            TreeNode tnParent = getParent();
            TreeNode tnThis = this;
            while (tnParent != null && tnThis == tnParent.getFirstChild()) {
                tnThis = tnParent;
                tnParent = tnParent.getParent();
            }
            //no parent found, i.e. the analyzed virtual token is the first
            //one in the tree. Therefore it begins at offset 0 
            if (tnParent == null) {
                return 0;
            }
            //we found such a node, now get the index of the node 
            //that has the offset of -1
            int sibIdx = tnThis.getSiblingIndex();
            //return the endOffset of its left sibling + 1, meaning that we
            //let the virtual token start right behind the previous (real) token
            return tnParent.getChild(sibIdx - 1).getEndOffset() + 1;
        }
        
        public int getEndOffset() {
            if (isLocked()) {
                return -1;
            }            
            //first find an ancestor node for which we have a real endOffset
            TreeNode tnParent = getParent();
            TreeNode tnThis = this;
            while (tnParent != null && tnThis == tnParent.getLastChild()) {
                tnThis = tnParent;
                tnParent = tnParent.getParent();
            }
            //no parent found, i.e. the analyzed virtual token is the last
            //one in the tree. No idea how long the original file was, so return
            //-1 to indicate infinity 
            if (tnParent == null) {
                return -1;
            }
            //we found such a node, now get the index of the node 
            //that has the offset of -1
            int sibIdx = tnThis.getSiblingIndex();
            //return the endOffset of its left sibling + 1, meaning that we
            //let the virtual token start right behind the previous (real) token
            return tnParent.getChild(sibIdx + 1).getOffset() - 1;
        }           
    }

	public Object deleteChild(Object t, int i) {
		TreeNode tn = (TreeNode)t;
		TreeNode tnChild = tn.getChild(i);
		((TreeNode)t).removeChild(tnChild);
		return tnChild;
	}


	public Object errorNode(TokenStream arg0, Token arg1, Token arg2,
			RecognitionException arg3) {

		return null;
	}


	public int getChildIndex(Object t) {
		TreeNode tn = (TreeNode)t;
		return tn.getSiblingIndex();
	}


	public Object getParent(Object t) {
		TreeNode tn = (TreeNode)t;
		return tn.getParent();
	}


	public void replaceChildren(Object arg0, int arg1, int arg2, Object arg3) {

		
	}


	public void setChild(Object arg0, int arg1, Object arg2) {

		
	}


	public void setChildIndex(Object arg0, int arg1) {

		
	}


	public void setParent(Object arg0, Object arg1) {

		
	}
    
    
}
