package org.deft.language.java.parser.antlradapter;

import java.util.HashMap;
import java.util.Map;

import org.antlr.runtime.Token;
import org.deft.language.java.parser.PositionConverter;


public abstract class Mapping {
	
	private Map<String, String> tokenTextMap = new HashMap<String, String>();
	private Map<Integer, String> tokenTypeMap = new HashMap<Integer, String>();
	private PositionConverter pConv;
	
	public Mapping(PositionConverter pConv) {
		this.pConv = pConv;
		setup();
	}
	
	protected abstract void setup();
	
	public int convertPosition(int line, int col) {
		return pConv.getOffset(line, col);
	}
	
	public void add(String tokenText, String tokenName) {
		tokenTextMap.put(tokenText, tokenName);
	}
	
	public void add(int tokenType, String tokenName) {
		tokenTypeMap.put(tokenType, tokenName);
	}
	
	public String getTokenName(String tokenText) {
		return tokenTextMap.get(tokenText);
	}
	
	public String getTokenName(int tokenType) {
		return tokenTypeMap.get(tokenType);
	}
	
	public String getTokenName(String tokenName, int tokenType) {
		if (tokenTextMap.containsKey(tokenName)) {
			return getTokenName(tokenName);
		}
		if (tokenTypeMap.containsKey(tokenType)) {
			return getTokenName(tokenType);
		}
		//if no special mappings for the token have been specified
		//use the tokenName
		return tokenName;
	}
	
	public String getTokenName(Token token) {
		return getTokenName(token.getText(), token.getType());
	}

}
