package org.deft.language.java.templates;

import java.util.HashSet;
import java.util.Set;

import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.decoration.NodeInformation;
import org.deft.repository.ast.decoration.tokentype.TokenTypeDecorator;
import org.deft.repository.ast.decoration.tokentype.TokenTypeInformation;


public class JavaTokenTypeDecorator extends TokenTypeDecorator {

	private Set<String> keywords = new HashSet<String>();
	private Set<String> builtinTypes = new HashSet<String>();

	public JavaTokenTypeDecorator() {
		setupSets();
	}

	
	
	private void setupSets() {
		keywords.add("ABSTRACT");
		keywords.add("ASSERT");
		keywords.add("BREAK");
		keywords.add("CASE");
		keywords.add("CATCH");
		keywords.add("CLASS");
		keywords.add("CONST");
		keywords.add("CONTINUE");
		keywords.add("DEFAULT");
		keywords.add("DO");
		keywords.add("ELSE");
		keywords.add("ENUM");
		keywords.add("EXTENDS");
		keywords.add("FINAL");
		keywords.add("FINALLY");
		keywords.add("FOR");
		keywords.add("GOTO");
		keywords.add("IF");
		keywords.add("IMPLEMENTS");
		keywords.add("IMPORT");
		keywords.add("INSTANCEOF");
		keywords.add("INTERFACE");
		keywords.add("NATIVE");
		keywords.add("NEW");
		keywords.add("NULL");
		keywords.add("PACKAGE");
		keywords.add("PRIVATE");
		keywords.add("PROTECTED");
		keywords.add("PUBLIC");
		keywords.add("RETURN");
		keywords.add("STATIC");
		keywords.add("STRICTFP");
		keywords.add("SWITCH");
		keywords.add("SYNCHRONIZED");
		keywords.add("THIS");
		keywords.add("THROW");
		keywords.add("THROWS");
		keywords.add("TRANSIENT");
		keywords.add("TRY");
		keywords.add("VOLATILE");
		keywords.add("WHILE");
		
		builtinTypes.add("BOOLEAN");
		builtinTypes.add("BYTE");
		builtinTypes.add("CHAR");
		builtinTypes.add("DOUBLE");
		builtinTypes.add("FLOAT");
		builtinTypes.add("INT");
		builtinTypes.add("LONG");
		builtinTypes.add("SHORT");
		builtinTypes.add("VOID");
		
	}

	@Override
	public void addTokenTypeInformation(TokenNode t) {
		if (builtinTypes.contains(t.getName())) {
			NodeInformation tti = new TokenTypeInformation("builtintype");
			t.addInformation(tti);
		} else if (keywords.contains(t.getName())) {
			NodeInformation tti = new TokenTypeInformation("keyword");
			t.addInformation(tti);
		} else if (t.getName().equals("NumberLiteral")) {
			NodeInformation tti = new TokenTypeInformation("number");
			t.addInformation(tti);
		} else if (t.getName().equals("StringLiteral")) {
			NodeInformation tti = new TokenTypeInformation("string");
			t.addInformation(tti);
		} else if (t.getName().equals("CharacterLiteral")) {
			NodeInformation tti = new TokenTypeInformation("char");
			t.addInformation(tti);
		} else if (t.getName().equals("BooleanLiteral")) {
			NodeInformation tti = new TokenTypeInformation("boolean");
			t.addInformation(tti);
		} else if (t.getName().equals("NullLiteral")) {
			NodeInformation tti = new TokenTypeInformation("null");
			t.addInformation(tti);
		} else
		
			//comment stuff
		if (t.getName().equals("Comment")) {
			NodeInformation tti = new TokenTypeInformation("comment");
			t.addInformation(tti);
		}
	}

}
