package org.deft.repository.ast;

import java.util.HashSet;
import java.util.Set;

/**
 * A MergeConfiguration describes how multiple ASTs should be merged if the
 * token positions allow multiple solutions.
 *  
 * @author abartho
 */
public class MergeConfiguration {
    
    private Set<String> nodesToRemove = new HashSet<String>();
    private Set<String> before = new HashSet<String>();
    private Set<String> after = new HashSet<String>();
    
    public MergeConfiguration() {
    }
    
    public void noteForRemoval(String name) {
        nodesToRemove.add(name);
    }
    
    public boolean shallBeRemoved(String name) {
        return nodesToRemove.contains(name);
    }
    
    public void forbidInsert(String name) {
        forbidInsertBefore(name);
        forbidInsertAfter(name);
    }
    
    public void forbidInsertBefore(String name) {
        before.add(name);
    }
    
    public void forbidInsertAfter(String name) {
        after.add(name);
    }    
    
    public boolean isInsertBeforeForbidden(String name) {
        return before.contains(name);
    }
    
    public boolean isInsertAfterForbidden(String name) {
        return after.contains(name);
    }
    
    
    public void clear() {
        nodesToRemove.clear();
        before.clear();
        after.clear();
    }
    

}
