package org.deft.repository.ast;

import java.io.Serializable;

public class Position implements Serializable{
	
	private static final long serialVersionUID = 4539962807123546363L;
	private int startLine;
	private int startCol;
	private int endLine;
	private int endCol;
	private int offset;
	private int length;
	
	public Position(){
		this(1,1,1,1,1,1);
	}
	
	public Position(TreeNode node) {
		this.startLine = node.getStartLine();
		this.startCol = node.getStartCol();
		this.endLine = node.getEndLine();
		this.endCol = node.getEndCol();
		this.offset = node.getOffset();
		this.length = node.getLength();
	}
	
	public Position(int startLine, int startCol, int endLine, 
			int endCol, int offset, int length){
		this.startLine = startLine;
		this.startCol = startCol;
		this.endLine = endLine;
		this.endCol = endCol;
		this.offset = offset;
		this.length = length;
	}

	public int getStartLine() {
		return startLine;
	}

	public int getStartCol() {
		return startCol;
	}

	public int getEndLine() {
		return endLine;
	}

	public int getEndCol() {
		return endCol;
	}

	public int getOffset() {
		return offset;
	}

	public int getLength() {
		return length;
	}
	
	@Override
	public String toString() {
		return "["+startLine+","+startCol+","+endLine+","+endCol
				+","+offset+","+length+"]";
	}
	
}
