package org.deft.repository.ast;

import org.deft.repository.ast.TreeNode;

public class SplitTreeNode extends TreeNode {
    
    private SplitTreeNode predecessor, successor;
    
    /**
     * Constructor for testing purposes
     */
    public SplitTreeNode(String name) {
        super(name);
    }
    
    public SplitTreeNode(TreeNode origNode) {
        super(origNode.getName());
        if (!origNode.hasChildren()) {
            lock();
            setOffset(origNode.getOffset());
            setEndOffset(origNode.getEndOffset());
        }
    }
    
    public void setOffset(int offset) {
        super.setOffset(offset);
    }
    
    public void setEndOffset(int endOffset) {
        super.setEndOffset(endOffset);
    }

    public void setPredecessor(SplitTreeNode predecessor) {
        this.predecessor = predecessor;
    }
    
    public void setSuccessor(SplitTreeNode successor) {
        this.successor = successor;
    }

    public SplitTreeNode getPredecessor() {
        return predecessor;
    }

    public SplitTreeNode getSuccessor() {
        return successor;
    }
    
    public boolean hasPredecessor() {
        return predecessor != null;
    }
    
    public boolean hasSuccessor() {
        return successor != null;
    }
    
    

}
