package org.deft.repository.ast;

//TODO I: modified
public class Token {
	
	protected int line, col, offset;
	protected String text;
	private String[] split;
	protected Position position;
	
	public Token(int line, int col, int offset, String text) {
		this.text = text;
		split = splitText();
		this.line = line;
		this.col = col;
		this.offset = offset;
	}
	
	public Token(String text, Position position){
		this.text = text;
		split = splitText();
		this.line = position.getStartLine();
		this.col = position.getStartCol();
		this.offset = position.getOffset();
	}
	
	public void setLine(int newLine){
		this.line = newLine;	
	}
	
	public void setCol(int newCol){
		this.col = newCol; 
	}
	
	public int getCol() {
		return col;
	}
	
	public int getLine() {
		return line;
	}
	
	public int getEndLine() {
		int nrLines = split.length;
		int endLine = line + nrLines - 1;
		return endLine;
	}
	
	public int getEndCol() {
		//end col is start + stringlength
		int endCol = col + text.length();
		//but if text spans multiple lines, endcol is stringlength
		//of last line
		if (split.length > 1) {
			endCol = split[split.length - 1].length();
		}
		return endCol;

	}
	
	public String getText() {
		return text;
	}
	
	public int getOffset() {
		return offset;
	}
	
	public int getLength() {
		return text.length();
	}
	
	public String[] splitText() {
		return text.split("\\n");
	}

	// TODO I: added below
	public void setOffset(int newOffset) {
		this.offset = newOffset;
	}

	public boolean isSingleLine() {
		return split.length == 1;
	}

	public int countLines() {
		return split.length;
	}

	public void moveCol(int offset) {
		col += offset;
	}

	public void moveLine(int offset) {
		line += offset;
	}

	
}
