package org.deft.repository.ast;

import java.util.Collections;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

/**
 * TokenNodes are the leaves of the
 * new TreeNode-AST. They contain a token from the original source code.
 * 
 * @author Andreas Bartho
 */
public class TokenNode extends TreeNode {
    
    private Token token;
    
	public TokenNode(String name, Token token) {
		super(name);
		this.token = token;
	}
    
    public Token getToken() {
        return token;
    }
    
    /**
     * Creates an XML text node. This method is when the tree is serialized
     * to XML in the exporter.
     * 
     * @param doc
     * @return
     */
    public Node makeXml(Document doc) {
        Node n = doc.createTextNode(token.getText());
        return n;
    }
    
    
    public String toString() {
        return "TokenNode: " + name + " - " + token.getText();
    }
    
    public int getStartLine() {
        return token.getLine();
    }
    
    public int getStartCol() {
        return token.getCol();
    }
    
    public int getEndLine() {
        return token.getEndLine();
    }
    
    public int getEndCol() {
        return token.getEndCol();
    }
    
    public int getOffset() {
        return token.getOffset();
    }
    
    public int getEndOffset() {
        return token.getOffset() + token.getLength();
    }
    
    public int getLength() {
        return token.getLength();
    }
    
    public void serialize(List<TokenNode> list) {
        list.add(this);
    }
    
}
