package org.deft.repository.ast;

import java.util.Comparator;

public class TokenNodeComparator implements Comparator<TokenNode> {

    public int compare(TokenNode tn1, TokenNode tn2) {
        Token t1 = tn1.getToken();
        Token t2 = tn2.getToken();
        if ((t1.getLine() < t2.getLine()) ||( t1.getLine() == t2.getLine() && t1.getCol() < t2.getCol())) {
            return -1;
        }
        if ((t1.getLine() > t2.getLine()) ||( t1.getLine() == t2.getLine() && t1.getCol() > t2.getCol())) {
            return 1;
        }        
        return 0;
    }


    
    

}
