package org.deft.repository.ast;

import java.util.List;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.deft.repository.ast.jxpath.TreeNodePointer;
import org.deft.repository.ast.jxpath.TreeNodePointerFactory;

/**
 * This is not a real tree node. It's just that JXPath can climb through the
 * object tree.
 * @author Frank Herrlich
 *
 */
public class TreeNodeRoot extends TreeNode {
	private JXPathContext context;
	
	static {
		JXPathContextReferenceImpl.addNodePointerFactory(new TreeNodePointerFactory());
	}
	
	public TreeNodeRoot(TreeNode child) {
		super("root");
		//do not use the normal addChild() method,
		//the child should not know its TreeNodeRoot
		//as parent
		children.add(child);
		child.setTnr(this);
	}	
	
	public TreeNodeRoot(List<TreeNode> children) {
		super("root");
		//do not use the normal addChild() method,
		//the child should not know its TreeNodeRoot
		//as parent
		this.children = children;
		for (TreeNode child : children) {
			child.setTnr(this);			
		}
	}
	
	public void addChild(TreeNode child) {
		children.add(child);
		child.setTnr(this);
	}
	
	public JXPathContext getContext() {
		if (context == null)		
			context = JXPathContext.newContext(this);
		return context;
	}	
	
	public TreeNodePointer getPointer()	{
		return new TreeNodePointer(null, this);
	}
	
	public TreeNodeRoot getTreeNodeRoot() {
    	return this;
    }
}
