package org.deft.repository.ast.decoration.astname;

import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.NodeInformation;
import org.deft.repository.ast.decoration.TemplatesBasic;

public class AstNameInformation extends NodeInformation {
    
    private String name;
    
    public AstNameInformation(String name) {
        this.name = name; 
    }
    
    public Ident getIdent() {
        return TemplatesBasic.ASTNAME;
    }
    
    public String getAstName() {
        return name;
    }
    
	@Override
	public NodeInformation copy() {
		return new AstNameInformation(name);
	}

	@Override
	public void addContentFromOtherNodeInformation(NodeInformation newInformation) {
	}

}
