package org.deft.repository.ast.jxpath;

import org.apache.commons.jxpath.ri.Compiler;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodePointer;

@SuppressWarnings("serial")
public class AttributePointer extends NodePointer {
	
	private final Object value;
	
	protected AttributePointer(NodePointer parent, Object value) {
		super(parent);
		this.value = value;
	}

	@Override
	public String asPath() {
        StringBuffer buffer = new StringBuffer();
        if (parent != null) {
            buffer.append(parent.asPath());
            if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
                buffer.append('/');
            }
        }
        buffer.append('@');
        buffer.append(getName());
        return buffer.toString();
    }

	@Override
	public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
		return 0;
	}
	
	public boolean equals(Object object) {
        if (object == this)
            return true;

        if (!(object instanceof AttributePointer))
            return false;

        return value.equals(((AttributePointer) object).value);
    }

	@Override
	public Object getBaseValue() {
		return getValue();
	}

	@Override
	public Object getImmediateNode() {
		return getValue();
	}

	@Override
	public int getLength() {
		return 0;
	}

	@Override
	public QName getName() {
		return null;
	}

	public Object getValue() {		
        return value;
    }
	
	public int hashCode() {
        return System.identityHashCode(value);
    }

	@Override
	public boolean isActual() {
		return true;
	}
	
	@Override
	public boolean isCollection() {
		return false;
	}
	
	@Override
	public boolean isLeaf() {
		return false;
	}
	
	@Override
	public void setValue(Object value) {
		throw new UnsupportedOperationException();
	}
	
	@Override
	public boolean testNode(NodeTest nodeTest) {
		if (nodeTest == null)
			return true;
		
		if (nodeTest instanceof NodeTypeTest)
			return ((NodeTypeTest) nodeTest).getNodeType() == Compiler.NODE_TYPE_NODE;
		
		
        return false;
    }
}
