package org.deft.repository.ast.jxpath;

import java.util.LinkedList;
import java.util.List;

import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.NodeInformation;
import org.deft.repository.ast.decoration.astname.AstNameInformation;

public class AttributePointerIterator implements NodeIterator {
	
	private final TreeNodePointer parent;
	private final QName name;
	
	private List<Object> attributes = new LinkedList<Object>();
	
	private int currentPosition = 0;
	
	public AttributePointerIterator(TreeNodePointer parent, QName name) {
		this.parent = parent;
		this.name = name;
		addAttribute();
	}
	
	private void addAttribute() {		
		String n = name.getName();
			
		if (n.equals("*")) {
			attributes.add(getParentValue().getStartLine());
			attributes.add(getParentValue().getStartCol());
			attributes.add(getParentValue().getEndLine());
			attributes.add(getParentValue().getEndCol());
			attributes.add(getParentValue().getOffset());
			attributes.add(getParentValue().getLength());
			attributes.addAll(getParentValue().getInformation());
			return;
		}
			
		if (n.equals("startline"))
			attributes.add(getParentValue().getStartLine());
		else if (n.equals("startcol"))
			attributes.add(getParentValue().getStartCol());
		else if (n.equals("endline"))
			attributes.add(getParentValue().getEndLine());
		else if (n.equals("endcol"))
			attributes.add(getParentValue().getEndCol());
		else if (n.equals("offset"))
			attributes.add(getParentValue().getOffset());
		else if (n.equals("length"))
			attributes.add(getParentValue().getLength());
		else 
			for (NodeInformation info : getParentValue().getInformation()) {
				AstNameInformation astNameInformation = (AstNameInformation) info;
				if (n.equals(info.getIdent().getIdString()))
					attributes.add(astNameInformation.getAstName());
			}
	}

	private TreeNode getParentValue() {
		return (TreeNode)parent.getValue();
	}
	
	public NodePointer getNodePointer() {
		if (currentPosition == 0) {
            if (!setPosition(1))
                return null;
           
            currentPosition = 0;
        }
		
		int index = currentPosition - 1;
        if (index < 0)
            index = 0;
        
        return new AttributePointer(parent, attributes.get(index));
	}

	public int getPosition() {
		return currentPosition;
	}

	public boolean setPosition(int position) {
		currentPosition = position;
		return (currentPosition > 0) && (currentPosition <= attributes.size());
	}

}
