package org.deft.repository.ast.jxpath;

import java.util.Locale;

import org.apache.commons.jxpath.ri.Compiler;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.TreeNodeRoot;

@SuppressWarnings("serial")
public class TreeNodePointer extends NodePointer {
	
	private TreeNode treeNode;
	
	public TreeNodePointer(NodePointer parent, TreeNode treeNode) {
		super(parent);
		this.treeNode = treeNode;
	}
	
	public TreeNodePointer(TreeNode treeNode, Locale locale) {
		super(null, locale);
		this.treeNode = treeNode;
	}
	
	public static boolean testNode(TreeNode treeNode, NodeTest test) {
		if (test == null)
            return true;
		
        if (test instanceof NodeNameTest) {
        	NodeNameTest nodeNameTest = (NodeNameTest) test;
        	if (nodeNameTest.isWildcard())
        		return true;
            return nodeNameTest.getNodeName().getName().equals(treeNode.getName());
        }
        else if (test instanceof NodeTypeTest) {
            switch (((NodeTypeTest) test).getNodeType()) {
			case Compiler.NODE_TYPE_NODE:
				return true;
			}
        }
        
       throw new UnsupportedOperationException();
    }

	@Override
	public String asPath() {
		if (treeNode instanceof TreeNodeRoot) {
			return "";
		}
			
		return super.asPath();
	}
	
	@Override
	public NodeIterator attributeIterator(QName name) {
        return new AttributePointerIterator(this, name);
    }

	@Override
	public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
		if (reverse)
			throw new UnsupportedOperationException();
		return new TreeNodePointerIterator(this, test);
	}

	@Override
	public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
		TreeNode treeNode1 = (TreeNode)pointer1.getBaseValue();
		TreeNode treeNode2 = (TreeNode)pointer2.getBaseValue();
		
		if (treeNode1 == treeNode2)
			return 0;
		
		return -1;
	}

	@Override
	public boolean equals(Object object) {
        if (object == this)
            return true;
        
        if (!(object instanceof TreeNodePointer))
        	return false;
        
        return treeNode == ((TreeNodePointer)object).treeNode;
    }

	@Override
	public TreeNode getBaseValue() {
		return treeNode;
	}

	@Override
	public Object getImmediateNode() {
		return treeNode;
	}

	@Override
	public int getLength() {
		return 1;
	}

	@Override
	public QName getName() {
		return new QName(treeNode.getName());
	}
    
	@Override
	public boolean isCollection() {
		return false;
	}
	
	@Override
	public boolean isLeaf() {
		return !treeNode.hasChildren();
	}
	
	@Override
	public void setValue(Object value) {
		throw new UnsupportedOperationException();
	}
	
	@Override
	public boolean testNode(NodeTest test) {
		return testNode(treeNode, test);
    }
}
