package org.deft.repository.ast.jxpath;

import java.util.Locale;

import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.deft.repository.ast.TreeNode;

public class TreeNodePointerFactory implements NodePointerFactory {

	public NodePointer createNodePointer(QName name, Object treeNode, Locale locale) {
		if (treeNode instanceof TreeNode)
			return new TreeNodePointer((TreeNode)treeNode, locale);
		
		return null;
	}

	public NodePointer createNodePointer(NodePointer parent, QName name, Object treeNode) {
		if (treeNode instanceof TreeNode)
			return ((TreeNode)treeNode).getPointer();
		return null;
	}

	public int getOrder() {
		return 0;
	}
}
