package org.deft.repository.ast.jxpath;

import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.deft.repository.ast.TreeNode;

public class TreeNodePointerIterator implements NodeIterator {
	
	private final NodeTest nodeTest;
	private final TreeNodePointer parent;
	private final TreeNode node;
	private int currentPosition = 0;
	private int currentChildIndex = 0;
	private TreeNode child;
	
	public TreeNodePointerIterator(TreeNodePointer parent, NodeTest nodeTest) {
		this.parent = parent;		
		this.nodeTest = nodeTest;
		this.node = parent.getBaseValue();
	}
	
	public NodePointer getNodePointer() {
		if (currentPosition == 0)
			if (!setPosition(1))
				return null;
		return new TreeNodePointer(parent, child);
	}
 
	public int getPosition() {
		return currentPosition;
	}

	public boolean setPosition(int position) {
		if (position == currentPosition)
			return true;
		
		//check if the iteration process for this node is over
		if (currentChildIndex >= node.getChildCount())
		{
			//because the Iterator is reused we need to reset the position for each new iteration.
			currentChildIndex = 0;
			return false;
		}
		
		while (currentPosition < position) {
			currentPosition++;
			if (!next())
				return false;
		}		
		return true;
	}

	private boolean next() {
		while (currentChildIndex < node.getChildCount()) {			
			child = node.getChild(currentChildIndex);
			currentChildIndex++;
			
			if (TreeNodePointer.testNode(child, nodeTest))
				return true;			
		}
		return false;
	}
}
