package org.deft.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.deft.repository.ast.decoration.Format;


/**
 * 
 * 
 * 
 * Handles all default code snippet formats.
 *
 */
public class XfsrFormatManager {
	
	private HashMap<String,List<Format>> defaultFormatList = new HashMap<String,List<Format>>();
	private static XfsrFormatManager manager;
	
	private XfsrFormatManager(){
	}
	
	public static XfsrFormatManager getInstance() {
		if (manager == null) {
			manager = new XfsrFormatManager();
		}
		return manager;
	}
	
	public void addDefaultFormat(String parserID, Format format) {
		//add to the list of default formats
		List<Format> formatList = defaultFormatList.get(parserID);
		if(formatList == null){
			formatList = new ArrayList<Format>();
			defaultFormatList.put(parserID, formatList);
		}
		formatList.add(format);
	
	}

	public Format getFormats(String parserId, String formatName) {
		List<Format> l = defaultFormatList.get(parserId);
		for (Format f : l) {
			if (f.getName().equals(formatName)) {
				return f;
			}
		}
		return null;
	}
	
}

