package org.deft.repository;

import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.Format;
import org.deft.repository.ast.decoration.DecoratorSelection;
import org.deft.repository.ast.decoration.OutputXmlCreator;
import org.deft.repository.query.Query;
import org.deft.repository.query.XfsrQueryManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlFileSystemRepository {

	XfsrQueryManager queryManager = new XfsrQueryManager();




	public Node getXmlContentTree(TreeNode ast, Query query, Format format, DecoratorSelection decoratorSelection) {
		
		if (format == null) {
			format = new Format("unchanged");
		}
		
		TreeNode queriedAst = executeQuery(ast, query, format);
		TreeNode node = queryManager.cutAndFormat(queriedAst);
		
		OutputXmlCreator outputCreator = new OutputXmlCreator(node, decoratorSelection);

		
		
		Document doc = outputCreator.createOutputXml();
		return doc.getDocumentElement();

	}
	
	
	

	public TreeNode executeQuery(TreeNode codeFileAst, Query query, Format format) {
		queryManager.queryAndFormat(codeFileAst, query, format, null);
		return codeFileAst;
	}
}
