package org.deft.repository;

import java.util.LinkedList;
import java.util.List;

import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;


/**
 * Parses an XML file that contains an algorithm definition and converts it
 * into a map containing trees of {@link AlgoControlNode AlgoControlNodes} which
 * the {@link AlgorithmController} needs. The creation of the Nodes is done in
 * two steps. First
 */
public abstract class XmlToRepositoryContentConverter extends XmlToDataConverter {

    //private XfsrFragmentManager stateManager;
    protected XmlFileSystemRepository rep;
    
    private LinkedList errorList = new LinkedList();
    
    public XmlToRepositoryContentConverter(XmlFileSystemRepository rep, String schemaFileName) {
    	super(schemaFileName, true);
        this.rep = rep;
    	//this.stateManager = rep.getStateManager();
    }


    
    
    public abstract ContentHandler getContentHandler();/* {
        return new ReadXmlRepositoryContentHandler();
    }*/

    public ErrorHandler getErrorHandler() {
        return new ReadXmlRepositoryContentErrorHandler();
    }

    public void initializeData() {
        errorList.clear();
    }

    public void postProcess() {

    }




    public List getErrors() {
        return errorList;
    }

 

    private class ReadXmlRepositoryContentErrorHandler implements ErrorHandler {

        public void warning(SAXParseException e) {
            setError(true);
            addXmlError(XmlToDataConverter.XML_WARNING, e.getLineNumber(), e.getColumnNumber(), e.getMessage());
        }

        public void error(SAXParseException e) {
            setError(true);
            addXmlError(XmlToDataConverter.XML_ERROR, e.getLineNumber(), e.getColumnNumber(), e.getMessage());
        }

        public void fatalError(SAXParseException e) {
            setError(true);
            addXmlError(XmlToDataConverter.XML_FATAL_ERROR, e.getLineNumber(), e.getColumnNumber(), e.getMessage());
        }

    }

 

}