package org.deft.repository.ast.annotation.csformat;

import java.util.List;

import org.deft.repository.ast.TokenNode;
import org.deft.repository.ast.TreeNode;
import org.deft.repository.ast.decoration.AstDecorator;
import org.deft.repository.ast.decoration.Ident;
import org.deft.repository.ast.decoration.Templates;
import org.deft.repository.ast.decoration.line.LineInformation;


public class CSFormatDecorator extends AstDecorator {

	
	@Override
    public void applyDecoration(TreeNode root) {
    	List<TokenNode> tokenNodes = root.serialize();
        for (TokenNode tn : tokenNodes) {
        	Integer line = tn.getStartLine();
        	LineInformation li = new LineInformation(line); 
            tn.addInformation(li);
        }
    }

	
    @Override
    public void buildAndAddGroupLists(List<TokenNode> tokens) {
    }
	


	@Override
	public Ident getIdent() {
		return Templates.CSFORMAT;
	}

	
}
